
local assets=
{
	Asset("ANIM", "anim/zg_we_zhongzheng.zip"),
    Asset("ANIM", "anim/zg_we_zhongzheng_swap.zip"), 
    Asset("ATLAS", "images/inventoryimages/zg_we_zhongzheng.xml"),
}

local prefabs = 
{
	"impact",
}


local function onequip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_object", "zg_we_zhongzheng_swap", "zg_we_zhongzheng_swap")
	owner.AnimState:Show("ARM_carry") 
	owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
	owner.AnimState:ClearOverrideSymbol("swap_object")
	owner.AnimState:Hide("ARM_carry") 
	owner.AnimState:Show("ARM_normal") 
end

local function onhit(inst, attacker, target)
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.Default)
	inst.AnimState:PlayAnimation("idle")
	
	local impactfx = SpawnPrefab("impact")
	if impactfx and attacker then
		local follower = impactfx.entity:AddFollower()
		follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
		impactfx:FacePoint(attacker.Transform:GetWorldPosition())
	end
end

local function thrownfn(inst)
	inst.AnimState:PlayAnimation("thrown")
end

local function onthrown(inst, data)
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
end


local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	MakeInventoryPhysics(inst)
	inst.AnimState:SetBank("zg_we_zhongzheng")
    inst.AnimState:SetBuild("zg_we_zhongzheng")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("shadow")
	inst:AddTag("projectile")
	
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "zg_we_axefly"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/zg_we_axefly.xml"
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(100)
	inst.components.finiteuses:SetUses(10)
	inst.components.finiteuses:SetOnFinished(inst.drop)
	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.inventoryitem.keepondeath = true

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(100)
	inst.components.weapon:SetRange(11,13)
	
	inst:AddComponent("projectile")
	inst.components.projectile:SetSpeed(64)
	inst.components.projectile:SetOnHitFn(onhit)
	inst.components.weapon:SetProjectile("fire_projectile")
	inst:ListenForEvent("onthrown", onthrown)

	return inst
end

return Prefab( "cz83", fn, assets, prefabs)
